<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 24.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName($_GET['username']);
requireLogin();
requireRole('Administrator');
initializeDatabaseConnection();

// Benutzerdaten aus der Datenbank holen
$sql = "SELECT ID, Type, Username, DisplayName, Role FROM Accounts WHERE Username = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$_GET['username']]);

$user = $stmt->fetch();

if (!$user or $user['ID'] == 1) {
    header("Location: /administration/accounts");
    exit();
}

// Alle verfügbaren Zonen abrufen
$zones = $pdo->query("SELECT * FROM Zones")->fetchAll(PDO::FETCH_ASSOC);

// Bereits zugewiesene Zonen für den Account abrufen
$assignedZonesStmt = $pdo->prepare("SELECT ZoneID FROM ZonePermissions WHERE AccountID = :account_id");
$assignedZonesStmt->execute(['account_id' => $user['ID']]);
$assignedZones = $assignedZonesStmt->fetchAll(PDO::FETCH_COLUMN);

// Neues Passwort setzen
if (isset($_POST['setNewPassword'])) {
    if ($_POST['password'] == $_POST['confirm_password']) {
        initializeDatabaseConnection();

        $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $sql = "UPDATE Accounts SET Password = :password WHERE username = :username";
        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(':password', $hashedPassword);
        $stmt->bindParam(':username', $_GET['username']);

        if ($stmt->execute()) {

            // AuditLog: Eintrag erstellen
            addAuditLog($_SESSION['Username'], 'Benutzerkonto', 'Neues Passwort für "' . $_GET['username'] . '" festgelegt');

            // Alert: Erfolgsmeldung (Passwort erfolgreich geändert)
            sweetAlert('', 'Das Passwort wurde erfolgreich geändert!', 'success');

        }
    }
}

// Benutzerkonto aktualisieren
if (isset($_POST['saveAccount'])) {
    initializeDatabaseConnection();

    if ($_POST['displayName']) {
        $sql = "UPDATE Accounts SET DisplayName = :displayname WHERE username = :username";
        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(':displayname', $_POST['displayName']);
        $stmt->bindParam(':username', $_GET['username']);

        $stmt->execute();
    }

    if ($_POST['accountRole']) {
        $sql = "UPDATE Accounts SET Role = :role WHERE username = :username";
        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(':role', $_POST['accountRole']);
        $stmt->bindParam(':username', $_GET['username']);

        $stmt->execute();
    }

    // Zonenberechtigungen setzen
    $selectedZones = $_POST['zones'] ?? []; // Die ausgewählten Zonen (Array)

    try {
        // Beginne die Transaktion
        $pdo->beginTransaction();

        // Entferne alte Zuweisungen für den Account
        $deleteStmt = $pdo->prepare("DELETE FROM ZonePermissions WHERE AccountID = :account_id");
        $deleteStmt->execute(['account_id' => $user['ID']]);

        // Neue Zuweisungen einfügen
        $insertStmt = $pdo->prepare("INSERT INTO ZonePermissions (ZoneID, AccountID) VALUES (:zone_id, :account_id)");
        foreach ($selectedZones as $zoneId) {
            $insertStmt->execute([
                'zone_id' => $zoneId,
                'account_id' => $user['ID']
            ]);
        }

        // Transaktion abschließen
        $pdo->commit();

    } catch (Exception $e) {
        // Rollback bei Fehler
        $pdo->rollBack();
    }

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Benutzerkonto', 'Daten von Benutzerkonto "' . $_GET['username'] . '" aktualisiert');

    // Alert: Erfolgsmeldung
    createSessionAlert("", "Benutzerkonto <h4 class='pt-2 pb-2'>" . $_GET['username'] . "</h4> wurde erfolgreich aktualisiert", "success", "false", "3000");

    // Weiterleitung zur Übersicht
    header("Location: /administration/accounts");
    exit();

}

// Benutzerkonto Löschen
if (isset($_POST['deleteAccount'])) {

    // Löschen der Zonenberechtigungen
    deleteDBEntry('ZonePermissions', 'AccountID', $user['ID']);

    // Löschen des Benutzerkontos
    deleteDBEntry('Accounts', 'Username', $_GET['username']);

    // Log
    addAuditLog($_SESSION['Username'], 'Benutzerkonto', 'Benutzerkonto "' . $_GET['username'] . '" gelöscht');

    // Alert: Erfolgsmeldung
    createSessionAlert("", "Benutzerkonto <h4 class='pt-2 pb-2'>" . $_GET['username'] . "</h4> wurde erfolgreich gelöscht", "success", "false", "3000");

    // Weiterleitung zur Übersicht
    header("Location: /administration/accounts");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>
<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-3 mb-md-0"><?php echo htmlspecialchars($user['Username']); ?></h4>
        <span class="text-secondary">Benutzerkonto</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">
        <button type="button" name="accountDelete" class="btn btn-danger btn-icon-text mb-2 mb-md-0 me-2"
            data-bs-toggle="modal" data-bs-target="#modalDeleteAccount">
            <i class="btn-icon-prepend" data-feather="trash-2"></i>
            Löschen
        </button>
        <a href="/administration/accounts" class="btn btn-secondary btn-icon mb-2 mb-md-0">
            <i data-feather="corner-up-left"></i>
        </a>
    </div>
</div>

<div class="row">

    <div class="col-lg-12 col-xl-8 grid-margin">
        <div class="card">
            <form action="" method="post" id="editProfile">
                <div class="card-header bg-primary text-white">
                    Benutzerdaten
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="current_username" class="form-label">Benutzername</label>
                        <input id="current_username" class="form-control" type="text"
                            value="<?php echo $user['Username']; ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="displayName" class="form-label">Vollständiger Name</label>
                        <input id="displayName" class="form-control" name="displayName" type="text"
                            value="<?php echo $user['DisplayName']; ?>" <?php if ($user['Type'] == 'ldap') {
                                   echo 'disabled';
                               } ?>>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Rolle</label>
                        <select class="js-example-basic-single form-select form-control" id="accountRole"
                            name="accountRole" data-width="100%">
                            <option value="Bediener" <?php if ($user['Role'] == 'Bediener') {
                                echo 'selected';
                            } ?>>
                                Bediener</option>
                            <option value="Bearbeiter" <?php if ($user['Role'] == 'Bearbeiter') {
                                echo 'selected';
                            } ?>>
                                Bearbeiter</option>
                            <option value="Auswerter" <?php if ($user['Role'] == 'Auswerter') {
                                echo 'selected';
                            } ?>>
                                Auswerter</option>
                            <option value="Auditor" <?php if ($user['Role'] == 'Auditor') {
                                echo 'selected';
                            } ?>>
                                Auditor</option>
                            <option value="Administrator" <?php if ($user['Role'] == 'Administrator') {
                                echo 'selected';
                            } ?>>Administrator</option>
                        </select>
                    </div>

                    <div class="mb-3" id="selectZones" style="display: none;">
                        <label for="zones">Zonenberechtigungen</label>
                        <select name="zones[]" id="zones" class="js-example-basic-multiple form-select"
                            multiple="multiple" data-width="100%">
                            <?php foreach ($zones as $zone): ?>
                                <option value="<?= htmlspecialchars($zone['ZoneID']) ?>" <?= in_array($zone['ZoneID'], $assignedZones) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($zone['ZoneName']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <input class="btn btn-primary" type="submit" name="saveAccount" value="Speichern">
                </div>
            </form>
        </div>
    </div>
    <div class="col-lg-12 col-xl-4 grid-margin">
        <div class="card">
            <form action="" method="post" id="editPassword">
                <div class="card-header bg-warning text-white">
                    Passwort
                </div>
                <div class="card-body">
                    <?php if ($user['Type'] == 'local') { ?>
                        <div class="mb-3">
                            <label for="password" class="form-label">Neues Passwort</label>
                            <input id="password" class="form-control" name="password" type="password">
                        </div>
                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">Passwort bestätigen</label>
                            <input id="confirm_password" class="form-control" name="confirm_password" type="password">
                        </div>
                        <input class="btn btn-primary" type="submit" name="setNewPassword" value="Speichern">
                    <?php } else { ?>
                        <div class="alert alert-light" role="alert">Da dieses Benutzerkonto ein Domänenkonto ist, kann das
                            Passwort nur auf dem Domänencontroller zurückgesetzt werden.</div>
                    <?php } ?>
                </div>
            </form>
        </div>
    </div>

</div>

<!-- Modal : Benutzerkonto Löschen -->
<div class="modal fade" id="modalDeleteAccount" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Benutzerkonto Löschen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    <p>Möchten Sie das Benutzerkonto dauerhaft löschen?</p>
                    <p>Dieser Vorgang kann nicht rückgängig gemacht werden.</p>
                    <?php if ($user['Type'] == 'ldap') { ?>
                        <div class="alert alert-light mt-3" role="alert">Um das Benutzerkonto endgültig zu löschen,
                            entfernen Sie bitte die Zuordnung des Benutzers zur Gruppe „CampGuard_Nutzer“ auf dem
                            Domänencontroller. Andernfalls wird das Konto beim nächsten Login automatisch neu erstellt.
                        </div>
                    <?php } ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                    <button type="submit" class="btn btn-danger" name="deleteAccount">Löschen</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    // Funktion zum Aktualisieren der Sichtbarkeit von #selectZones
    function updateZoneVisibility() {
        const accountRole = $('#accountRole').val(); // Den Wert des Select2-Dropdowns abrufen
        const selectZone = document.getElementById('selectZones');

        // Prüfen, ob die ausgewählte Rolle "Bediener" ist
        if (accountRole === 'Bediener') {
            selectZone.style.display = 'block'; // Zeige das Feld an
        } else {
            selectZone.style.display = 'none'; // Verstecke das Feld
        }
    }

    $(document).ready(function () {
        // Initialisiere Select2 für das accountRole-Feld
        $('#accountRole').select2();

        // Eventlistener für Änderungen am Select2-Dropdown
        $('#accountRole').on('change', updateZoneVisibility);

        // Initiale Prüfung beim Laden der Seite
        updateZoneVisibility();
    });

</script>